﻿Public Class frmMain
    Inherits System.Windows.Forms.Form

    Private Class cPTSClientWrapper 'wrapper for the PTS web service proxy; 
        Inherits com.masscec_pts.ar.PTS_AR   'this is the reference to the PTS web service
        Protected Overrides Function GetWebRequest(ByVal uri As System.Uri) As System.Net.WebRequest
            'this disables keep-alives to avoid problems with different SOAP clients
            Dim oWR As Net.HttpWebRequest = MyBase.GetWebRequest(uri)
            oWR.KeepAlive = False
            Return oWR
        End Function
    End Class

    Private Sub PostToPts(ByVal xmlstring As String)

        Dim oClient As New cPTSClientWrapper
        Dim oAuth As New com.masscec_pts.ar.cAuthentication
        With oAuth
            .UserName = Me.txtPtsUserName.Text
            .Password = Me.txtPtsPassword.Text
        End With
        '        Dim sResult As String
        Me.tabXMLView.SelectedTab = tabXmlResults

        Try
            With oClient
                .cAuthenticationValue = oAuth
                Me.txtXMLResults.Text = .postdata(xmlstring)

                If cbSaveResults.Checked Then
                    Dim strResultsFileName As String
                    strResultsFileName = IIf(IsNothing(txtDefaultFilePath.Text), "C:\", _
                                             IIf(InStrRev(txtDefaultFilePath.Text, "\") = Len(txtDefaultFilePath.Text), "", txtDefaultFilePath.Text + "\")) _
                                                + "ARUploadResults_" + DateTime.Now.ToString("yyyyMMdd_HHmmss") + "_POST.xml"

                    If cbShowSqlMsgBox.Checked Then MsgBox(strResultsFileName, MsgBoxStyle.Information, "POSTDATA Results Filename")

                    Dim oFile As System.IO.FileStream = IO.File.OpenWrite(strResultsFileName)
                    Dim buffer(Me.txtXMLResults.Text.Length - 1) As Byte
                    Dim encoder As New System.Text.ASCIIEncoding()

                    encoder.GetBytes(Me.txtXMLResults.Text, 0, Me.txtXMLResults.Text.Length, buffer, 0)
                    oFile.Seek(oFile.Length, IO.SeekOrigin.Begin)
                    oFile.Write(buffer, 0, buffer.Length)
                    oFile.Close()

                End If
            End With
        Catch ex As Exception
            Me.txtXMLResults.Text = ex.Message & vbCrLf & ex.StackTrace
        Finally
            Try
                oClient = Nothing
                oAuth = Nothing
            Catch ex As Exception
                Me.txtXMLResults.Text = ex.Message
            End Try

        End Try
    End Sub
    Private Sub TestPostToPts(ByVal xmlstring As String)
        'this is the test web method; it will not
        'actually record the data, but is identical to the real method other than that
        Dim oClient As New cPTSClientWrapper    'wrapper class for web service proxy
        Dim oAuth As New com.masscec_pts.ar.cAuthentication    'authentication object needed to use the service
        With oAuth  'fill in with your PTS username & password (System Representative account)
            'this account must be the account specified as System Representitive for the 
            'systems that you'll be posting data for
            .UserName = Me.txtPtsUserName.Text
            .Password = Me.txtPtsPassword.Text
        End With
        '        Dim sResult As String
        Me.tabXMLView.SelectedTab = tabXmlResults


        Try
            With oClient
                .cAuthenticationValue = oAuth
                Me.txtXMLResults.Text = .testpostdata(xmlstring)   'This posts the contents of the main textbox
                ' to the web service, then writes the return message to the same textbox
                'The return value is in XML format; the schema for the return value is located here:
                'https://ar.masscec-pts.com/ARResults.xsd

                If cbSaveResults.Checked Then
                    Dim strResultsFileName As String
                    strResultsFileName = IIf(IsNothing(txtDefaultFilePath.Text), "C:\", _
                                             IIf(InStrRev(txtDefaultFilePath.Text, "\") = Len(txtDefaultFilePath.Text), "", txtDefaultFilePath.Text + "\")) _
                                                + "ARUploadResults_" + DateTime.Now.ToString("yyyyMMdd_HHmmss") + "_TEST.xml"

                    If cbShowSqlMsgBox.Checked Then MsgBox(strResultsFileName, MsgBoxStyle.Information, "TESTPOST Results Filename")

                    Dim oFile As System.IO.FileStream = IO.File.OpenWrite(strResultsFileName)
                    Dim buffer(Me.txtXMLResults.Text.Length - 1) As Byte
                    Dim encoder As New System.Text.ASCIIEncoding()

                    encoder.GetBytes(Me.txtXMLResults.Text, 0, Me.txtXMLResults.Text.Length, buffer, 0)
                    oFile.Seek(oFile.Length, IO.SeekOrigin.Begin)
                    oFile.Write(buffer, 0, buffer.Length)
                    oFile.Close()

                End If

            End With
        Catch ex As Exception
            Me.txtXMLResults.Text = ex.Message & vbCrLf & ex.StackTrace
        Finally
            Try
                oClient = Nothing
                oAuth = Nothing
            Catch ex As Exception
                Me.txtXMLResults.Text = ex.Message
            End Try

        End Try
    End Sub
    Private Sub btnFindFile_Click(sender As Object, e As EventArgs) Handles btnFindFile.Click
        Dim openFileDialog1 As New OpenFileDialog()

        With openFileDialog1
            .Title = "Select an AR input file"
            .InitialDirectory = IIf(IsNothing(txtDefaultFilePath.Text), "C:\", txtDefaultFilePath.Text)
            .Filter = "XML Files (*.xml)|*.xml|Excel Files (*.xlsx)|*.xlsx"
            .FilterIndex = IIf(rbSQLServer.Checked, 1, 2)

            If .ShowDialog() = System.Windows.Forms.DialogResult.OK Then
                txtUploadFilePath.Text = .FileName.ToString()

                If .DefaultExt = "xml" Then
                    Dim sr As New System.IO.StreamReader(.FileName)
                    Me.txtXMLUpload.Text = sr.ReadToEnd
                    sr.Close()
                End If
            End If

        End With
    End Sub

    Private Sub btnTestPost_Click(sender As Object, e As EventArgs) Handles btnTestPost.Click
        TestPostToPts(Me.txtXMLUpload.Text)

    End Sub

    Private Sub btnPostData_Click(sender As Object, e As EventArgs) Handles btnPostData.Click
        PostToPts(Me.txtXMLUpload.Text)

    End Sub

    Function LoadData() As String

        'Clear the XML text boxes to receieve new data and select the upload tab
        Me.txtXMLUpload.Clear()
        Me.txtXMLResults.Clear()
        Me.tabXMLView.SelectedTab = tabXmlUpload
        Me.Refresh()

        If rbSQLServer.Checked Then
            Return LoadDataFromSQl()
        Else
            Return LoadDataFromXL()
        End If


    End Function
    Function LoadDataFromSQl() As String

        Dim sSelect As String
        Dim sConnect As String

        sConnect = txtConnection.Text

        'replace the tokens with the ID and Password values if they are used
        sConnect = Replace(sConnect, "%UserID%", txtDSUserName.Text)
        sConnect = Replace(sConnect, "%UserPass%", txtDSPassword.Text)

        If cbShowSqlMsgBox.Checked Then MsgBox(sConnect, MsgBoxStyle.Information, "AR Upload Connection Statement")

        'Use the connection string to open your local database from the Settings tab txtConnection textbox
        Dim cnn As New SqlClient.SqlConnection(txtConnection.Text)
        Dim cmd As New SqlClient.SqlCommand

        'use the SELECT statement from the Settings tab txtSQL textbox
        sSelect = txtSQL.Text

        'replace the tokens with the start and end date values if they are used
        sSelect = Replace(sSelect, "%Start%", dtpStartDate.Text)
        sSelect = Replace(sSelect, "%End%", dtpEndDate.Text)

        'replace the tokens with the ID and Password values if they are used
        sSelect = Replace(sSelect, "%UserID%", txtDSUserName.Text)
        sSelect = Replace(sSelect, "%UserPass%", txtDSPassword.Text)

        If cbShowSqlMsgBox.Checked Then MsgBox(sSelect, MsgBoxStyle.Information, "AR Upload SQL Statement")

        cmd.CommandText = sSelect
        cmd.Connection = cnn
        Dim oDataAdapter As New SqlClient.SqlDataAdapter(cmd)
        Dim oDataset As ARData
        Dim oTempTable As New Data.DataTable
        Try
            cnn.Open()
            oDataAdapter.Fill(oTempTable) 'Fill a temp table with data from local database
            'Me.txtNumSystems.Text = CStr(oTempTable.Rows.Count)
            oDataset = FilledDataset(oTempTable) 'call FilledDataset to build a dataset of type ARData
            'To add a reference to this class in your project, you select "Add Existing Item" from the project menu, 
            'and instead of browsing to a local file, type or paste in:
            'https://ar.masscec-pts.com/PTS-AR.xsd
            'This will add a reference to the ARData class
            Return oDataset.GetXml  'return the XML representation of the filled dataset
        Catch ex As Exception
            Return ex.Message & vbCrLf & ex.StackTrace
        Finally
            If cnn.State <> ConnectionState.Closed Then
                cnn.Close()
            End If
        End Try

    End Function
    Function LoadDataFromXL() As String

        Dim sSelect As String
        Dim sConnect As String

        sConnect = txtConnection.Text
        'Use the connection string to open your local database from the Settings tab txtConnection textbox
        sConnect = Replace(sConnect, "%XLFile%", txtUploadFilePath.Text)

        'replace the tokens with the ID and Password values if they are used
        sConnect = Replace(sConnect, "%UserID%", txtDSUserName.Text)
        sConnect = Replace(sConnect, "%UserPass%", txtDSPassword.Text)

        If cbShowSqlMsgBox.Checked Then MsgBox(sConnect, MsgBoxStyle.Information, "AR Upload Connection Statement")

        Dim cnn As New OleDb.OleDbConnection(sConnect)
        Dim cmd As New OleDb.OleDbCommand

        'use the SELECT statement from the Settings tab txtSQL textbox
        sSelect = txtSQL.Text

        'replace the tokens with the start and end date values if they are used
        sSelect = Replace(sSelect, "%Start%", dtpStartDate.Text)
        sSelect = Replace(sSelect, "%End%", dtpEndDate.Text)

        'replace the tokens with the ID and Password  values if they are used
        sSelect = Replace(sSelect, "%UserID%", txtDSUserName.Text)
        sSelect = Replace(sSelect, "%UserPass%", txtDSPassword.Text)

        If cbShowSqlMsgBox.Checked Then MsgBox(sSelect, MsgBoxStyle.Information, "AR Upload SQL Statement")

        cmd.CommandText = sSelect
        cmd.Connection = cnn
        Dim oDataAdapter As New OleDb.OleDbDataAdapter(cmd)
        Dim oDataset As ARData
        Dim oTempTable As New Data.DataTable
        Try
            cnn.Open()
            oDataAdapter.Fill(oTempTable) 'Fill a temp table with data from spreadsheet
            'Me.txtNumSystems.Text = CStr(oTempTable.Rows.Count)
            oDataset = FilledDataset(oTempTable) 'call FilledDataset to build a dataset of type ARData
            'To add a reference to this class in your project, you select "Add Existing Item" from the project menu, 
            'and instead of browsing to a local file, type or paste in:
            'https://ar.masscec-pts.com/PTS-AR.xsd
            'This will add a reference to the ARData class
            Return oDataset.GetXml  'return the XML representation of the filled dataset
        Catch ex As Exception
            Return ex.Message & vbCrLf & ex.StackTrace
        Finally
            If cnn.State <> ConnectionState.Closed Then
                cnn.Close()
            End If
        End Try

    End Function
    Private Enum TableColumns   'this maps the dataset to the local database columns 
        'returned by the select statement; it is used in the FilledDataset function to 
        'transfer data from the local query to the structured dataset required by the web service
        SystemID = 0
        SystemType = 1
        kwhRegistry = 2
        regDateTime = 3
        ' these fields are really not used by AR or PTS any longer. No need to require them in input stream from XL or SQL
        'kwAcOutput = 4
        'avgTempInF = 5
        'avgWindSpeedInMPH = 6
        'avgIrradiance = 7
        'CurrentInclination = 8
        'CurrentAzimuth = 9
    End Enum
    Private Function FilledDataset(ByVal TempTable As DataTable) As ARData
        'This is the main function that populates a dataset in order to generate the xml for the web service
        'It will need to be edited to match the particular data fields that you'll be posting
        'The dataset needs to be constructed carefully since the XML structure needs to be exact
        'in terms of element order and heirarchy
        Dim oDS As New ARData   'defined by https://ar.masscec-pts.com/PTS-AR.xsd

        Dim i As Integer
        For i = 0 To TempTable.Rows.Count - 1   'loop through data
            Dim oTempTableRow As DataRow = TempTable.Rows(i)

            'The following code builds the dataset in the proper order and heirarchy
            'The first block populates the monthly data by finding the last row 
            'of the local data table
            Dim oSysTable As ARData.ptsSystemDataTable = oDS.ptsSystem
            ' Dim oIntervalTable As ARData.intervalDataDataTable
            Dim oMonthlyTable As ARData.MonthlyDataDataTable
            Dim oPVMonthly As ARData.PVmonthlyDataDataTable
            Dim oSysRow As ARData.ptsSystemRow = oSysTable.NewptsSystemRow
            oSysRow.sysID = oTempTableRow(TableColumns.SystemID)
            oSysRow.sysType = oTempTableRow(TableColumns.SystemType)


            oSysTable.Rows.Add(oSysRow)
            oMonthlyTable = oSysTable.ChildRelations("ptsSystem_MonthlyData").ChildTable
            oPVMonthly = oMonthlyTable.ChildRelations("MonthlyData_PVmonthlyData").ChildTable

            Dim oMonRow As ARData.MonthlyDataRow = oMonthlyTable.NewMonthlyDataRow
            oMonRow.ptsSystemRow = oSysRow
            oMonthlyTable.Rows.Add(oMonRow)
            Dim oPVMonRow As ARData.PVmonthlyDataRow = oPVMonthly.NewPVmonthlyDataRow

            With oPVMonRow
                .kwhRegistry = oTempTableRow(TableColumns.kwhRegistry) 'use the TableColumns enum to map the data
                .regDateTime = oTempTableRow(TableColumns.regDateTime)
            End With
            oPVMonRow.MonthlyDataRow = oMonRow
            oPVMonthly.Rows.Add(oPVMonRow)
        Next

        'return the filled dataset
        Return oDS

    End Function


    Private Sub btnSetPath_Click(sender As Object, e As EventArgs) Handles btnSetPath.Click
        Dim openFolderDialog1 As New FolderBrowserDialog()

        openFolderDialog1.Description = "Select the folder that holds the AR input XML or Excel file(s)."
        openFolderDialog1.SelectedPath = IIf(IsNothing(txtDefaultFilePath.Text), Application.StartupPath, txtDefaultFilePath.Text)

        If openFolderDialog1.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
            txtDefaultFilePath.Text = openFolderDialog1.SelectedPath
        End If

    End Sub

    Private Sub frmMain_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        txtProgramVersion.Text = Application.ProductVersion

        'because the SQL radio button is set from the settings, if it is false, it does not set the excel radio button to true
        'trying to set both from settings causes other problems
        If Not rbSQLServer.Checked Then
            rbExcel.Checked = True
        End If

    End Sub

    Private Sub btnSave_Click(sender As Object, e As EventArgs) Handles btnSave.Click
        My.Settings.Save()

    End Sub

    Private Sub btnCreateXML_Click(sender As Object, e As EventArgs) Handles btnCreateXML.Click
        Me.txtXMLUpload.Text = Me.LoadData

    End Sub

    Private Sub picGNULicense_Click(sender As Object, e As EventArgs) Handles picGNULicense.Click
        Dim webAddress As String = "https://www.gnu.org/licenses/gpl.html"
        Process.Start(webAddress)

    End Sub

    Private Sub picMasscecLogo_Click(sender As Object, e As EventArgs) Handles picMasscecLogo.Click
        Dim webAddress As String = "http://www.masscec.com/"
        Process.Start(webAddress)

    End Sub

    Private Sub picMSVS_Click(sender As Object, e As EventArgs) Handles picMSVS.Click
        Dim webAddress As String = "https://www.visualstudio.com/"
        Process.Start(webAddress)

    End Sub

End Class
